/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 *  @author    Mensagia.com
 *  @copyright 2010-2015 Sinermedia
 *  @license   LICENSE.txt
 */

var demo    = false;

var options = {
    exporting                       : false,
    prefix_agenda                   : null,
    delete_agendas                  : null,
    blacklist_with_newsletter       : null,
    blacklists                      : [],
    limit                           : 500,
    jobs                            : 0,
    jobs_done                       : 0,
    groups                          : [],
    next_index_group_to_export      : null,
    export_started                  : false,
    processes                       : [],
    contact_fields                  : [],
    extrafields                     : [],
    default_language_id             : null,
    date_format                     : null,
    date_format_full                : null,
    waiting_finish_processes        : false,
    finished                        : false,
    processes_checked_errors        : [],
    prefix_mode                     : null,
    total_rows_processed            : 0,
    total_created_contacts          : 0,
    total_imported_contacts         : 0,
    total_errors                    : 0,
    priority_field                  : "email",
}

$(document).ready(function(){

    $('[data-toggle="tooltip"]').tooltip();

    $(".groupsToExport").change(function() {
        infoGroupsToExport();
    });

    $(".radioBlacklist").change(function() {
        if ($(this).val() === "1")
            $(".listanegrabox").show();
        else
            $(".listanegrabox").hide();
    });

    $("#ps_phone, #ps_email").change(function() {
        setPriorityField();
    });

    $("#prefix_agenda").keyup(function() {
        infoGroupsToExport();
    });

    $(".markAll").change(function() {
        value = $(this).prop('checked');

        $(this).parent().parent().parent().find('input').each(function() {
            id = $(this).prop('id');
            $(this).prop('checked', value);
        });

        setPriorityField();

    });

    $(".btnExport").click(function() {

        errors = false;
        $(".error").hide();

        have_email  = $("input[name='ps_email']:checked").val() === "1";
        have_phone = $("input[name='ps_phone']:checked").val() === "1";

        // set priority field
        if (!have_phone && have_email)
            options.priority_field = 'email';
        else if (have_phone && !have_email)
            options.priority_field = 'number';
        else
            options.priority_field      = $("#priority_field").val();

        options.prefix_agenda       = $("#prefix_agenda").val();
        options.default_language_id = default_language_id;
        options.date_format_lite    = date_format_lite;
        options.date_format_full    = date_format_full;
        options.prefix_mode         = prefix_mode;

        options.delete_agendas = $("input[name='delete_agendas']:checked").val() === "1";
        options.blacklist_with_newsletter = $("input[name='blacklist_with_newsletter']:checked").val() === "1";

        if (options.blacklist_with_newsletter) {
            if ($("input[name='sms_blacklist']:checked").val() === "1")
                options.blacklists.push('in_sms_blacklist');

            if ($("input[name='mail_blacklist']:checked").val() === "1")
                options.blacklists.push('in_mail_blacklist');

            if ($("input[name='voz_blacklist']:checked").val() === "1")
                options.blacklists.push('in_voice_blacklist');
        } else
            options.blacklists = [];


        // groups
        $(".groupsToExport:checked").each(function() {
            options.groups.push({
                group_id: parseInt($(this).attr('group_id')),
                group_name: $(this).attr('group_name')
            });
        });

        // extrafields
        $(".ps_extrafields:checked").each(function() {

            options.extrafields.push({
                name: $(this).attr('id'),
                extra_field_type: $(this).attr('extra_field_type'),
                nameToShow: $(this).attr('nameToShow'),
                date_format_type: $(this).attr('date_format_type'),
                ps_group: $(this).attr('ps_group')
            });
        });

        // check contacts fields
        if ($("input[name='ps_phone']:checked").val() === "1")
            options.contact_fields.push('ps_phone');

        if ($("input[name='ps_email']:checked").val() === "1")
            options.contact_fields.push('ps_email');

        if ($("input[name='ps_name']:checked").val() === "1")
            options.contact_fields.push('ps_name');

        if ($("input[name='ps_city']:checked").val() === "1")
            options.contact_fields.push('ps_city');

        if ($("input[name='ps_language']:checked").val() === "1")
            options.contact_fields.push('ps_language');

        // check errors
        if (!options.groups.length) {
            $(".error_export").fadeIn();
            errors = true;
        }

        // miramos si hay al menos un campo primario escogido
        if (!have_email && !have_phone ) {
            $(".error_no_primary").fadeIn();
            errors = true;
        }

        // miramos si la opcion de añadir a la Lista Negra tiene seleccionadas Listas Negras
        if (options.blacklist_with_newsletter && !options.blacklists.length) {
            $(".error_no_blacklists").fadeIn();
            errors = true;
        }

        if (!errors) {

            if (demo) {
                $('#modalDemo').modal('toggle');
                return false;
            }

            if (! options.exporting)
            {
                options.exporting = true;

                block_export_button();

                export_init();

                goToByScroll('exportBox');
            }
        }
    });

});

function block_export_button()
{
    $(".btnExport").fadeOut();
    $(".panel-export").fadeIn();
}

function unblock_export_button()
{
    $(".btnExport").prop('disabled', false);
    $(".loaderImg").hide();
    $(".imageExport").show();
}

function export_init()
{
    $.ajax({
        url: '../modules/mensagiaprestashop/ajax/ajax_export.php',
        data:{
            action: 'export_init',
            token: new Date().getTime(),
            options: JSON.stringify( options ),
            language_id: language_id
        },
        method: 'POST',
        type: 'JSON',
        success: function(result){

            data = JSON.parse(result);

            options = data['options'];
            $(".export_process").append(data['html']);
            $(".export_process_errors").append(data['errors']);

            if (data['continue'])
            {
                if (options.delete_agendas)
                    delete_agendas();
                else
                    create_agendas();
            }
        }
    });
}

function export_error()
{
    $(".progress").hide();
    $(".exportError").fadeIn();
}


function export_finished()
{
    $(".progress-bar").removeClass('progress-bar-info').addClass('progress-bar-success');

    $.ajax({
        url: '../modules/mensagiaprestashop/ajax/ajax_export.php',
        data:{
            action: 'export_finished',
            token: new Date().getTime(),
            options: JSON.stringify( options )
        },
        method: 'POST',
        type: 'JSON',
        success: function(result){
            data = JSON.parse(result);

            options = data['options'];
            $(".export_process").append(data['html']);
            $(".export_process_errors").append(data['errors']);
        }
    });
}

function waitingFinishProcesses()
{
    $.ajax({
        url: '../modules/mensagiaprestashop/ajax/ajax_export.php',
        data:{
            action: 'waiting_finish_processes',
            token: new Date().getTime(),
            options: JSON.stringify( options )
        },
        method: 'POST',
        type: 'JSON',
        success: function(result){
            data = JSON.parse(result);

            options = data['options'];
            $(".export_process").append(data['html']);
            $(".export_process_errors").append(data['errors']);

            refresh_progress_bar();

            if (data['continue'] == true)
            {
                if (options.finished)
                    export_finished();
                else
                    setTimeout(function(){waitingFinishProcesses()}, 5000);
            }
            else
                export_error();
        }
    });
}


function export_groups()
{
    $.ajax({
        url: '../modules/mensagiaprestashop/ajax/ajax_export.php',
        data:{
            action: 'export_groups',
            token: new Date().getTime(),
            options: JSON.stringify( options )
        },
        method: 'POST',
        type: 'JSON',
        success: function(result){
            data = JSON.parse(result);

            options = data['options'];
            $(".export_process").append(data['html']);
            $(".export_process_errors").append(data['errors']);

            refresh_progress_bar();

            if (data['continue'] == true)
            {
                if (options.next_index_group_to_export !== null)
                    setTimeout(function(){export_groups(), 5000});
                else
                    waitingFinishProcesses();
            }
            else
                export_error();
        }
    });
}


function check_extrafields()
{
    $.ajax({
        url: '../modules/mensagiaprestashop/ajax/ajax_export.php',
        data:{
            action: 'check_extrafields',
            token: new Date().getTime(),
            options: JSON.stringify( options )
        },
        method: 'POST',
        type: 'JSON',
        success: function(result){
            data = JSON.parse(result);

            options = data['options'];
            $(".export_process").append(data['html']);
            $(".export_process_errors").append(data['errors']);

            refresh_progress_bar();

            if (data['continue'] == true)
                export_groups();
            else
                export_error();
        }
    });
}


function create_agendas()
{
    $.ajax({
        url: '../modules/mensagiaprestashop/ajax/ajax_export.php',
        data:{
            action: 'create_agendas',
            token: new Date().getTime(),
            options: JSON.stringify( options )
        },
        method: 'POST',
        type: 'JSON',
        success: function(result){
            data = JSON.parse(result);

            options = data['options'];
            $(".export_process").append(data['html']);
            $(".export_process_errors").append(data['errors']);

            refresh_progress_bar();

            if (data['continue'] == true)
                check_extrafields();
            else
                export_error();
        }
    });
}

function delete_agendas()
{
    if (options.delete_agendas)
    {
        $.ajax({
            url: '../modules/mensagiaprestashop/ajax/ajax_export.php',
            data:{
                action: 'delete_agendas',
                token: new Date().getTime(),
                options: JSON.stringify( options )
            },
            method: 'POST',
            type: 'JSON',
            success: function(result){
                data = JSON.parse(result);

                options = data['options'];
                $(".export_process").append(data['html']);

                refresh_progress_bar();

                if (data['continue'] == true)
                    create_agendas();
                else
                    export_error();
            }
        });
    }
}

function refresh_progress_bar()
{
    // get actual width
    actual_width = $(".progress-bar").attr('aria-valuenow');

    // get new width
    width = ( options.jobs_done * 100 ) / options.jobs;


    if (actual_width != width)
    {
        $(".progress-bar").attr('aria-valuenow', width);

        $(".progress-bar").stop().animate({
            'width': width+"%"
        });

        if (width != 100)
            $(".progress-bar").html(width.toFixed(2)+"%");
        else
            $(".progress-bar").html("100%");
    }

    // scroll log always bottom
    $(".export_process").animate({ scrollTop: $(document).height() }, "slow");
    $(".export_process_errors").animate({ scrollTop: $(document).height() }, "slow");
}

function setPriorityField()
{
    have_email  = $("input[name='ps_email']:checked").val() === "1";
    have_phone = $("input[name='ps_phone']:checked").val() === "1";

    if (have_email && have_phone)
        $(".priority_field_box").fadeIn();
    else
        $(".priority_field_box").fadeOut();
}

function infoGroupsToExport()
{
    nameGroups = [];

    // groups
    $(".groupsToExport:checked").each(function() {
        nameGroups.push($("#prefix_agenda").val()+$(this).attr('group_name'));
    });

    if (nameGroups.length){
        $("#helpBlockAgendasNames").html(nameGroups.join(', '));
        $("#helpBlockAgendas").fadeIn();
    }
    else
    {
        $("#helpBlockAgendasNames").html('');
        $("#helpBlockAgendas").fadeOut();
    }
}

function goToByScroll(id)
{
    id = id.replace("link", "");

    // Scroll
    $('html,body').animate({
            scrollTop: $("#"+id).offset().top},
        'slow');
}

